﻿unit While_Loop_File_System;

interface

uses
  Classes, Common, DataEntry, DataStorage, DIRegex, SysUtils, Regex;

const
  ATRY_EXCEPT_STR = 'TryExcept: '; // noslz
  BM_FOLDER_SCRIPT_OUTPUT = 'Script Output';
  BS = '\';
  HYPHEN = ' - ';
  RPAD_VALUE = 35;
  RUNNING = '...';
  SCRIPT_NAME = 'Bookmark Graphics Classification';
  SPACE = ' ';
  STR_GRAPHICS_CLASSIFICATION = 'AI Graphics Classification';
  
var
  gbl_Email: boolean;
  gbl_FileSystem: boolean;

type
  Item_Record = class
    RecClassStr: string;
    RecEntry: TEntry;
    RecScoreInt: integer;
    RecScoreStr: string;
  end;

implementation

function RPad(AString: string; AChars: integer): string;
begin
  if AChars > length(AString) then
    Result := AString + StringOfChar(' ', AChars - length(AString))
  else
    Result := AString;
end;

function DeleteCharactersAfterFirstOpenParenthesis(const inputStr: string): string;
var
  indexOfOpenParenthesis: integer;
begin
  indexOfOpenParenthesis := Pos('(', inputStr);
  if indexOfOpenParenthesis > 0 then
    Result := trim(Copy(inputStr, 1, indexOfOpenParenthesis - 1))
  else
    Result := trim(inputStr);
end;

function PerlMatch(const AMatchPattern: string; const AMatchString: string): string;
var
  Re: TDIPerlRegEx;
begin
  Result := '';
  Re := TDIPerlRegEx.Create(nil);
  Re.CompileOptions := [coCaseLess, coUnGreedy];
  Re.SetSubjectStr(AMatchString);
  Re.MatchPattern := AMatchPattern;
  if Re.Match(0) >= 0 then
    Result := Re.matchedstr;
  FreeAndNil(Re);
end;

// =============================================================================
// Start of Script
// =============================================================================
var
  anEntry: TEntry;
  ARec: Item_Record;
  bm_comment: string;
  bm_counter: integer;
  bm_Folder: TEntry;
  bm_Parent: TEntry;
  cat_str: string;
  Category_StringList: TStringList;
  col_str: string;
  Collection_StringList: TStringList;
  Datastore: TDataStore;
  Field_GraphicClassification: TDataStoreField;
  i, j, s: integer;
  LineList: TStringList;
  score_str: string;
  sub_fldr_str: string;

begin
  Progress.DisplayTitle := SCRIPT_NAME;

  if not assigned(ScriptTask) then
    Datastore := GetDataStore(DATASTORE_FILESYSTEM)
  else
    Datastore := ScriptTask.DataStore;

  gbl_Email := False;
  gbl_FileSystem := False;  
  if DataStore.Name = DATASTORE_EMAIL then
    gbl_Email := True
  else
    gbl_FileSystem := True;

  if not assigned(Datastore) then
  begin
    Progress.Log('Not assigned a data store. The script will terminate.');
    Exit;
  end;

  try
    anEntry := Datastore.First;
    if not assigned(anEntry) then
    begin
      Progress.Log('No entries in the data store. The script will terminate.');
      Exit;
    end;

    Category_StringList := TStringList.Create;
    Collection_StringList := TStringList.Create;

    LineList := TStringList.Create;
    LineList.Delimiter := ',';
    LineList.StrictDelimiter := True;
    try
      Field_GraphicClassification := Datastore.DataFields.FieldByName['Graphic Classification']; // noslz (leave as text and do not translate)
      s := 0;
      bm_counter := 0;
      Progress.Initialize(Datastore.Count, 'Processing' + RUNNING);
      anEntry := Datastore.First;
      while assigned(anEntry) and (Progress.isRunning) do
      begin
        if Field_GraphicClassification <> nil then
        begin
          if (not Field_GraphicClassification.IsNull(anEntry)) and (not(Field_GraphicClassification.asString(anEntry) = '')) then
          begin
            Collection_StringList.Clear;
            ARec := Item_Record.Create;
            ARec.RecEntry := anEntry;
            col_str := Field_GraphicClassification.asString[anEntry];
            LineList.CommaText := col_str;
            for i := 0 to LineList.Count - 1 do
            begin
              cat_str := DeleteCharactersAfterFirstOpenParenthesis(LineList[i]);
              Category_StringList.Add(cat_str);
              score_str := (PerlMatch('(?<=\()(\s*\d{1,3})(?=\))', LineList[i])); // noslz
              ARec.RecClassStr := cat_str;
              ARec.RecScoreStr := score_str;
              ARec.RecScoreInt := 0;
              try
                ARec.RecScoreInt := StrToInt(trim(score_str));
              except
                Progress.Log(ATRY_EXCEPT_STR + SPACE + 'StrToInt: ' + score_str + SPACE + col_str); // noslz
              end;

              if ARec.RecScoreInt > 0 then
              begin
                // Progress.Log(col_str);
                // Progress.Log(RPad('FName:', RPAD_VALUE) + anEntry.EntryName);
                // Progress.Log(RPad('Class:', RPAD_VALUE) + ARec.RecClassStr);
                // Progress.Log(RPad('Score:', RPAD_VALUE) + inttostr(ARec.RecScoreInt));
                // Progress.Log('---');

                bm_comment := '';
                
                sub_fldr_str := '';
                if gbl_Email then sub_fldr_str := 'Email';
                if gbl_FileSystem then sub_fldr_str := 'File System';
                if sub_fldr_str <> '' then
                  sub_fldr_str := sub_fldr_str + BS;

                bm_Parent := FindBookmarkByName(BM_FOLDER_SCRIPT_OUTPUT + BS + STR_GRAPHICS_CLASSIFICATION + BS + sub_fldr_str + ARec.RecClassStr);
                if bm_Parent = nil then
                begin
                  bm_Parent := NewBookmark(FindDefaultBookmark(MY_BOOKMARKS_INDEX), BM_FOLDER_SCRIPT_OUTPUT + BS + STR_GRAPHICS_CLASSIFICATION + BS + sub_fldr_str + ARec.RecClassStr);
                end;

                for j := 0 to 9 do
                begin
                  if not Progress.isRunning then
                    Break;

                  if j <= 8 then
                  begin
                    if not Progress.isRunning then
                      Break;
                    if (ARec.RecScoreInt >= (j * 10)) and (ARec.RecScoreInt < (j * 10 + 10)) then
                    begin
                      bm_Folder := FindBookmarkByName(bm_Parent, inttostr(j * 10) + HYPHEN + inttostr(j * 10 + 9));

                      if bm_Folder = nil then
                        bm_Folder := NewBookmark(bm_Parent, inttostr(j * 10) + HYPHEN + inttostr(j * 10 + 9));

                      if not IsItemInBookmark(bm_Folder, anEntry) then
                        AddItemsToBookmark(bm_Folder, DATASTORE_FILESYSTEM, anEntry, bm_comment);

                      inc(bm_counter);
                    end;
                  end;

                  if j = 9 then
                  begin
                    if not Progress.isRunning then
                      Break;

                    if (ARec.RecScoreInt >= (j * 10)) and (ARec.RecScoreInt <= (j * 10 + 10)) then
                    begin
                      bm_Folder := FindBookmarkByName(bm_Parent, inttostr(j * 10) + HYPHEN + inttostr(j * 10 + 10));

                      if bm_Folder = nil then
                        bm_Folder := NewBookmark(bm_Parent, inttostr(j * 10) + HYPHEN + inttostr(j * 10 + 10));

                      if not IsItemInBookmark(bm_Folder, anEntry) then
                        AddItemsToBookmark(bm_Folder, DATASTORE_FILESYSTEM, anEntry, bm_comment);

                      inc(bm_counter);
                    end;
                  end;

                end;

              end;
            end;

          end;
        end;

        Progress.IncCurrentProgress;
        anEntry := Datastore.Next;
      end;

    finally
      Category_StringList.free;
      Collection_StringList.free;
      LineList.free;
      if assigned(ARec) then
        ARec.free;
    end;

  finally
    Datastore.free;
  end;

  Progress.Log('Script finished.');
end.
